package pogamutmysposhbot;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.MessageObjects.Health;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import java.util.logging.Level;
import java.util.logging.Logger;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.introspection.PogProp;
import java.util.Collections;
import cz.cuni.pogamut.MessageObjects.*;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour {
   
   
    /** whether the bot has been initialized */
    private boolean initialized = false;
    
    /** is used to store shuffled list of weapons bot runs around */
    private ArrayList<Item> itemsToRunAround = null;	
 
    /** choose med kits for the stateMedKit */
    protected ArrayList <Item> chosenMedKits = null;

    /** chosen item for the state seeItem */
    protected Item chosenItem = null;

    /** 
    * Stores last unreachable item - item that bot chose and was not able to go to. <br>
    * This setting should prevent bot from getting stuck.
    */
    protected Item previousChosenItem = null;
    
    /** counter for attempts in reaching the item */ 
	protected int walkingAttempts = 0;
    /** max attempts in reaching the item */
    protected final int MAX_ATTEMPTS = 3;
    
    /** see an enemy that has a better weapon than all of mine */
    protected boolean cannotRearm = false;
    
    /** walking mystic properties - prevent bot from continuous jumping - he will jump only once */
    private boolean jumped;
    
    // ENEMIES
    private Player lastEnemy = null;
    /** the enemy we're fixed at. If null no enemy is engaged. */
    private Player enemy = null;        
    
    /*******
     * AGENT SWITCHES!!! (ALL ON :)
    *******/
    /** boolean switch to activate engage */
    @PogProp public boolean shouldEngage = true;
    /** boolean switch to activate pursue */
    @PogProp public boolean shouldPursue = true;
    /** boolean switch to activate rearm */
    @PogProp public boolean shouldRearm = true;
    /** boolean switch to activate collect items */
    private boolean shouldCollectItems = true;
    /** boolean switch to prevent from engaging when the bot has a worse weapon */
    private boolean dontEngageWeak = false;         // always engage ;)
    /** how low the health level should be to start collecting healht */
    @PogProp public int healthLevel = 90;   
        
    /* not used
   private class KillListener implements RcvMsgListener {

       public KillListener() {
           bot.getBody().addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
       }
               
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            if ( enemy.UnrealID.equals(e.getMessage().UnrealID))
            {
                log.info("ENEMY KILLED");
                lastEnemy = enemy;
                enemy = null;
            }
        }
   }
   */
    
    
    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);
    }
    
    @Override
    public boolean action_doNothing() {
	this.log.info("Action doNothing() called.");
        try {			
            Thread.sleep(250);
            return true;
        } catch (InterruptedException e) {
            return false;
        }
    }
    
    /**
     * place to initialize the bot (not used - the drive is not in plan)
     */
    public void action_initialize() { 
        initialized = true;
    }
    
    /**
     * changes to a better weapon he posseses
     */
    public void action_rearm() {
        this.log.log(Level.INFO, "Decision is: REARM");
        AgentMemory memory = this.bot.getMemory();
        
        if (memory.getAgentLocation() == null || memory.getSeeEnemy() == null || memory.getSeeEnemy().location == null)
            return;
	AddWeapon weapon = memory.getBetterWeapon(memory.getAgentLocation(), memory.getSeeEnemy().location);
	if (weapon != null){
            cannotRearm = false;
            this.bot.getBody().changeWeapon(weapon);
        }
        else {
            cannotRearm = true;
            this.log.log(Level.INFO, "CANNOT REARM..");
        }
    }
    
    
    	/**
	 * Fired when bot see any enemy.
	 * <ol>
	 * <li> if have enemyID - checks whether the same enemy is visible, if not, drop him (and stop shooting)
	 * <li> if doesn't have enemyID - pick one of the enemy for pursuing
	 * <li> if not shooting at enemyID - start shooting
	 * <li> if out of ammo - switch to another weapon
	 * <li> if enemy is reachable - run to him
	 * <li> if enemy is not reachable - stand still (kind a silly, right? :-)
	 * </ol>
	 */
    public void action_engage() {
        AgentMemory memory = this.bot.getMemory();
        AgentBody body = this.bot.getBody();
        
	this.log.log(Level.INFO, "Decision is: ENGAGE");
	// 1) if have enemyID - checks whether the same enemy is visible, if not, drop ID (and stop shooting)
	if (this.enemy != null){
            this.lastEnemy = enemy;
            this.enemy = memory.getSeePlayer(this.enemy.ID); // refresh information about the enemy,
            // note that even though we've got pointer to the message of the enemy seen, it's still a certain message 
            // from a specific time - when new message arrives it's written as a new message
            if (this.enemy == null){			
                if (memory.isShooting())
                    body.stopShoot(); // stop shooting, we've lost target
                    return;
            }
        }
		
	// 2) if doesn't have enemy - pick one of the enemy for pursuing
	if (this.enemy == null){
		this.enemy = memory.getSeeEnemy();
		if (this.enemy == null){
			body.stop();
			body.stopShoot();
			return;				
		}
	}
		
	AddWeapon weapon = null;
	// 3) if out of ammo - switch to another weapon
	if ((!memory.hasLoadedWeapon()) && memory.hasAnyLoadedWeapon()) {
            this.log.info("no ammo - switching weapon " + memory.hasLoadedWeapon() + " " 
                               + memory.getAnyWeapon() + "\nCurrent Weapon:" + memory.getCurrentWeapon()
                               + "\nWeapons : " + memory.getAllWeapons().toString());
            weapon = memory.getAnyWeapon();
            if ((weapon != null) && ((memory.getCurrentWeapon() == null) || ((memory.getCurrentWeapon() != null) 
                && (!weapon.weaponType.equals(memory.getCurrentWeapon().weaponType))))) {
                this.log.info("no ammo - switching weapon: " + weapon);
                 body.changeWeapon(weapon);
            } else {
                this.log.info("Ran out of weapons?!");
                }
            }
		
	// 4) if not shooting at enemyID - start shooting
	double distance = (Triple.distanceInSpace(memory.getAgentLocation(), this.enemy.location));
	if (memory.getCurrentWeapon() != null && memory.getCurrentWeapon().maxDist > distance) {// it is worth shooting
            this.log.info("Would like to shoot at enemy!!!");
            if (!memory.isShooting())
                  body.shoot(this.enemy);
            else // to turn to enemy - shoot will not turn to enemy during shooting
                  body.turnToTarget(this.enemy);
        }
		
	// 5) if enemy is far - run to him
	int decentDistance = 750;
		
	if (memory.getAgentLocation() != null && this.enemy != null && this.enemy.location != null &&
		Triple.distanceInSpace(memory.getAgentLocation(), this.enemy.location) < decentDistance){
		if (memory.isMoving()){
			body.stop();
		}
	} else {
		body.runToTarget(enemy);
		this.jumped = false;
	}
    }
    
    
    /** stop shooting */
    public void action_stopShooting() {
        this.log.log(Level.INFO, "Decision is: STOP SHOOTING");
        this.bot.getBody().stopShoot();
    }
           
            
            
    /** Just turn horizontally */
    public void action_hit() {
        this.log.log(Level.INFO, "Decision is: TURN AROUND");
        this.bot.getBody().turnHorizontal(55);
        this.cannotRearm = false;
    }
    
    	/**
	 * Pursue enemy is for pursuing enemy who was for example lost behind a corner.
	 * How it works?:
	 * <ol>
	 * <li> initialize properties 
	 * <li> obtain path to the enemy
	 * <li> follow the path - if it reaches the end - set lastEnemy to null - bot would have seen him before or lost him once for all
	 * </ol>
	 */
    public void action_pursueEnemy() {
       	this.log.log(Level.INFO, "Decision is: PURSUE ENEMY");
        if(!this.bot.getMap().safeRunToLocation(lastEnemy.location)) {         // unable to reach the chosen item
            log.info("Ended at the enemy possition or failed - > STOP THE CHASE");
            previousChosenItem = chosenItem;
            lastEnemy = null;
        }
    }
    
    
    	/**
	 * Fired when bot is moving, checks few accidents than can happen to him
	 * <ol>
	 * <li> Wall collision
	 * <li> Fell of the bot
	 * <li> Bump to another actor of the game
	 * </ol>
	 */
    public void action_walk() {
        this.log.log(Level.INFO, "Decision is: WALKING");
	AgentBody body = this.bot.getBody();
        AgentMemory memory = this.bot.getMemory();
        
	if (memory.isColliding())
		if (!this.jumped){
			body.doubleJump();
			this.jumped = true;
		} else {
			body.stop();
			this.jumped = false;
		}
	if (memory.isFalling()){
		body.sendGlobalMessage("I am falling :O!");
		this.log.info("I'm flying like an angel to the sky ... it's so high ...");
	}
	if (memory.isBumpingToAnotherActor()){
		body.stop();
	}
    }
    
    /**
    * run along the path to choosen item
    */
    public void action_seeItem() {
        this.log.log(Level.INFO, "Decision is: SEE_ITEM --- Running for: " + this.chosenItem.toString());		                
        if(!this.bot.getMap().safeRunToLocation(chosenItem.location)) {         // unable to reach the choosen item
                     log.info("unable to REACH the choosen item");
                     previousChosenItem = chosenItem;
                     chosenItem = null;
        }
        this.jumped = false;
    }
    
    public void action_runAroundFotItems() {
 	this.log.log(Level.INFO, "Decision is: RUN AROUND ITEMS");
	this.bot.getMap().runAroundItemsInTheMap(this.itemsToRunAround, true);   // use A Star alg.
    }
    
    public boolean action_runAroundMeds() {
    	this.log.log(Level.INFO, "Decision is: RUN AROUND MED KITS"); 
        if ( chosenMedKits == null )
            return false;
        
        this.bot.getMap().runAroundItemsInTheMap(chosenMedKits, true);
        return true;
    }
    
    public boolean action_getHealth() {
    this.log.log(Level.INFO, "Decision is: GET HEALTH"); 
    if (this.chosenMedKits == null) 
            this.chosenMedKits = this.bot.getMap().nearestHealth(1, 8);
        return action_runAroundMeds();
    }
    
    /** get items to run around if the list is empty **/
    public void action_getItems() {
        this.log.log(Level.INFO, "Decision is: GET ITEMS (TO RUN AROUND)");     
        
        // get memory
        AgentMemory memory = this.bot.getMemory();
  
         // get items to run around
         this.log.log(Level.INFO, "getting itemsToRunAround");
 
         this.itemsToRunAround = new ArrayList<Item>();
	 for ( Item item : memory.getKnownWeapons())
         {
                this.log.log(Level.INFO, "adding weapons to my list");
	 	this.itemsToRunAround.add(item);
         }
	 for ( Item item : memory.getKnownArmors())
	 	this.itemsToRunAround.add(item);
	 Collections.shuffle(itemsToRunAround);
    }
    
    // Senses
    //-------
    
    /** not used now */
    public boolean sense_notInitialized() {
        return !initialized;
    }
    
    public boolean sense_shouldRearm() {
        return (this.shouldRearm && this.bot.getMemory().getSeeAnyEnemy() && this.hasBetterWeapon());
    }
    
    public boolean sense_canEngage() {
        return (this.shouldEngage && this.bot.getMemory().getSeeAnyEnemy() && (!this.cannotRearm && this.dontEngageWeak));
    }
    
    public boolean sense_isShooting() {
        return this.bot.getMemory().isShooting();
    }
    
    
    public boolean sense_beingDamaged() {
        return this.bot.getMemory().isBeingDamaged();
    }
    
    public boolean sense_hasAnyLoadedWeapon() {
        return this.bot.getMemory().hasAnyLoadedWeapon();
    }
    
    public boolean sense_enemyToPursue() {
        return ((this.lastEnemy != null) && (this.shouldPursue));
    }
    
    
    public boolean sense_isColliding() {
        return this.bot.getMemory().isColliding();
    }
    
    
    public boolean sense_shouldCollectItems() {
        return this.shouldCollectItems;
    }
    
    
    public boolean sense_seeAnyReachableItemAndWantIt() {
	if (this.bot.getMemory().getSeeAnyReachableItem()){
		chosenItem = chooseItem();
		if (chosenItem != null) {
			this.log.info("NEW ITEM CHOSEN: " + chosenItem);
			this.log.info("LAST CHOSEN ITEM: " + previousChosenItem);
                }
	} else {
		chosenItem = null;
	}
	if ((chosenItem != null) && (!chosenItem.equals(previousChosenItem)))
               return true;
        else
               return false;
    }
    
    
    public boolean sense_lowHealth() {
        return (this.bot.getMemory().getAgentHealth() < this.healthLevel);
    }
    
    
    public boolean sense_canRunAroundMeds() {
    if (this.chosenMedKits == null) {
			this.chosenMedKits = this.bot.getMap().nearestHealth(4, 8);
		}
		// no medkits to run to around the agent - restricted AStar - see nearestHealth
		if (chosenMedKits.isEmpty()) {
                        this.log.log(Level.INFO, "no medkits to run around");
			this.chosenMedKits = null;
			return false;
		}
		// bot is too close to the object - possibly standing at the only one
		if (Triple.distanceInSpace(chosenMedKits.get(0).location, this.bot.getMemory().getAgentLocation()) < 15) {
			// there are many - remove the first one - seeItem has highest priority, so bot should
			// pick up the item anyway and otherwise will not get stucked at the inventory spot of 
			// the item
			if (chosenMedKits.size() > 2)
				chosenMedKits.remove(0);
			else {
				this.chosenItem = null;
				return false;
			}
		}
		return true;
    }
    
    /** are itemsToRunAround empty? **/
    public boolean sense_itemsEmpty() {
        if ( itemsToRunAround == null )
            return true;
        
        return itemsToRunAround.isEmpty();
    }
    
    public boolean sense_fail() {
		this.log.info("Sense fail() called.");
        return false;
    }
    
    public boolean sense_succeed() {
		this.log.info("Sense succeed() called.");
        return true;
    }
    
    // Other methods
    //--------------
    
    	/**
	 * Reasoning about what to do with seen item <br>
	 * the easiest way of handeling it will be just to take it every time, but what should we do
	 * when there are many of items laying in front of agent?
	 * <ol>
	 * <li> choose weapon - choose the type he is lacking (melee/ranged)
	 * <li> choose armor
	 * <li> choose health - if the health is bellow normal maximum
	 * <li> choose ammo - if it is suitable for possessed weapons
	 * <li> ignore the item
	 * </ol>
	 */
    	private Item chooseItem() {
            AgentMemory memory = this.bot.getMemory();
            
		// 1) choose weapon - choose the type he is lacking (melee/ranged)
		if (memory.getSeeAnyReachableWeapon())
			return chooseWeapon();
		// 2) choose armor
		if (memory.getSeeAnyReachableArmor())
			return memory.getSeeReachableArmor();
		// 3) choose health - if the health is bellow normal maximum or the item is boostable
		if (memory.getSeeAnyReachableHealth()) {
			Health health = memory.getSeeReachableHealth();
			if (memory.getAgentHealth() < 100)
				return health;
			if (health.boostable) // if the health item is boostable, grab it anyway:)
				return health;
		}	
		// 4) choose ammo - if it is suitable for possessed weapons
		if ((memory.getSeeAnyReachableAmmo()) && 
			(memory.isAmmoSuitable(memory.getSeeReachableAmmo())))
			return memory.getSeeReachableAmmo();
		// 5) ignore the item
		return null;
	}
    
        
       /** 
	 * choose weapon according to the one he is currently holding
	 * <ol>
	 * <li> has melee and see ranged => pick up ranged
	 * <li> has ranged and see melee => pick up melee
	 * <li> pick up first weapon he sees
	 * </ol>
	 * 
	 * @return the choosen one weapon
	 */
	private Weapon chooseWeapon() {
            AgentMemory memory = this.bot.getMemory();
            
		ArrayList<Weapon> weapons = memory.getSeeReachableWeapons();			
		for (Weapon weapon:weapons) {
			// 0) has no weapon in hands
			if (memory.getCurrentWeapon() == null)
				return weapon;
			// 1) weapon is ranged, bot has melee
			if ((memory.getCurrentWeapon().melee) && !weapon.isMelee() && !memory.hasWeaponOfType(weapon.weaponType)){
				return weapon;
			}
			// 2) weapon is melee, bot has ranged
			if (!memory.getCurrentWeapon().melee && weapon.isMelee() && !memory.hasWeaponOfType(weapon.weaponType)){
				return weapon;
			}
		}
		Weapon chosen = memory.getSeeReachableWeapon();
		if (!memory.hasWeaponOfType(chosen.weaponType)){
			return chosen;
		}
		return null;
	}
        
        	/**
	 * has better weapon - this magic check goes through weapons in inventory and according to their characteristics
	 * decides which is the best - that means which effectiveDistance is lowest and which maximal distance is big enough
	 * to reach enemy.
	 * </p>
	 * <p>
	 * Note!: Both effective and maximal distance are guessed and therefore could not work exactly
	 * </p>
	 */
	protected boolean hasBetterWeapon() {
                AgentMemory memory = this.bot.getMemory();
                if (memory.getAgentLocation() == null || memory.getSeeEnemy() == null || memory.getSeeEnemy().location == null)
                    return false;
		AddWeapon weapon = memory.getBetterWeapon(memory.getAgentLocation(), memory.getSeeEnemy().location);
           
                if (weapon == null)
			return false;
		else
			return true;	
	}
}
